/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignatureProperty;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureProperties
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)SignatureProperties.class.getName());

    public SignatureProperties(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public SignatureProperties(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public int getLength() {
        Element[] propertyElems = XMLUtils.selectDsNodes(this._constructionElement, "SignatureProperty");
        return propertyElems.length;
    }

    public SignatureProperty item(int i) throws XMLSignatureException {
        try {
            Element propertyElem = XMLUtils.selectDsNode(this._constructionElement, "SignatureProperty", i);
            if (propertyElem == null) {
                return null;
            }
            return new SignatureProperty(propertyElem, this._baseURI);
        }
        catch (XMLSecurityException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    public void setId(String Id) {
        if (this._state == 0 && Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addSignatureProperty(SignatureProperty sp) {
        this._constructionElement.appendChild(sp.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public String getBaseLocalName() {
        return "SignatureProperties";
    }
}

