/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)X509SubjectNameResolver.class.getName());
    private Element[] _x509childNodes = null;
    private XMLX509SubjectName[] _x509childObject = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug((Object)"I can't");
            return false;
        }
        this._x509childNodes = XMLUtils.selectDsNodes(element, "X509SubjectName");
        if (this._x509childNodes != null && this._x509childNodes.length > 0) {
            log.debug((Object)"Yes Sir, I can");
            return true;
        }
        log.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            boolean weCanResolve;
            if (!(this._x509childNodes != null || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._x509childNodes != null)) {
                return null;
            }
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SubjectName"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                log.info((Object)"", (Throwable)ex);
                throw ex;
            }
            this._x509childObject = new XMLX509SubjectName[this._x509childNodes.length];
            for (int i = 0; i < this._x509childNodes.length; ++i) {
                this._x509childObject[i] = new XMLX509SubjectName(this._x509childNodes[i], BaseURI);
            }
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509SubjectName certSN = new XMLX509SubjectName(element.getOwnerDocument(), cert);
                log.debug((Object)("Found Certificate SN: " + certSN.getSubjectName()));
                for (int i = 0; i < this._x509childObject.length; ++i) {
                    log.debug((Object)("Found Element SN:     " + this._x509childObject[i].getSubjectName()));
                    if (certSN.equals(this._x509childObject[i])) {
                        log.debug((Object)"match !!! ");
                        return cert;
                    }
                    log.debug((Object)"no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException ex) {
            log.debug((Object)"XMLSecurityException", (Throwable)ex);
            throw new KeyResolverException("generic.EmptyMessage", ex);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

