/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SKI;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509SKIResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((String)X509SKIResolver.class.getName());
    private Element[] _x509childNodes = null;
    private XMLX509SKI[] _x509childObject = null;

    public boolean engineCanResolve(Element element, String BaseURI, StorageResolver storage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Can I resolve " + element.getTagName() + "?"));
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug((Object)"I can't");
            return false;
        }
        this._x509childNodes = XMLUtils.selectDsNodes(element, "X509SKI");
        if (this._x509childNodes != null && this._x509childNodes.length > 0) {
            log.debug((Object)"Yes Sir, I can");
            return true;
        }
        log.debug((Object)"I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        X509Certificate cert = this.engineResolveX509Certificate(element, BaseURI, storage);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        try {
            boolean weCanResolve;
            if (!(this._x509childNodes != null || (weCanResolve = this.engineCanResolve(element, BaseURI, storage)) && this._x509childNodes != null)) {
                return null;
            }
            if (storage == null) {
                Object[] exArgs = new Object[]{"X509SKI"};
                KeyResolverException ex = new KeyResolverException("KeyResolver.needStorageResolver", exArgs);
                log.info((Object)"", (Throwable)ex);
                throw ex;
            }
            this._x509childObject = new XMLX509SKI[this._x509childNodes.length];
            for (int i = 0; i < this._x509childNodes.length; ++i) {
                this._x509childObject[i] = new XMLX509SKI(this._x509childNodes[i], BaseURI);
            }
            while (storage.hasNext()) {
                X509Certificate cert = storage.next();
                XMLX509SKI certSKI = new XMLX509SKI(element.getOwnerDocument(), cert);
                for (int i = 0; i < this._x509childObject.length; ++i) {
                    if (!certSKI.equals(this._x509childObject[i])) continue;
                    log.debug((Object)("Return PublicKey from " + cert.getSubjectDN().getName()));
                    return cert;
                }
            }
        }
        catch (XMLSecurityException ex) {
            throw new KeyResolverException("empty", ex);
        }
        return null;
    }

    public SecretKey engineResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

