/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.w3c.dom.Element;

public class KeyResolver {
    static Log log = LogFactory.getLog((String)KeyResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    protected KeyResolverSpi _resolverSpi = null;
    protected StorageResolver _storage = null;

    private KeyResolver(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (KeyResolverSpi)Class.forName(className).newInstance();
    }

    public static int length() {
        return _resolverVector.size();
    }

    public static KeyResolver item(int i) throws KeyResolverException {
        KeyResolver resolver = (KeyResolver)_resolverVector.get(i);
        if (resolver == null) {
            throw new KeyResolverException("utils.resolver.noClass");
        }
        return resolver;
    }

    public static final KeyResolver getInstance(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        for (int i = 0; i < _resolverVector.size(); ++i) {
            KeyResolver resolver = (KeyResolver)_resolverVector.get(i);
            if (resolver == null) {
                Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
                throw new KeyResolverException("utils.resolver.noClass", exArgs);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("check resolvability by class " + resolver.getClass()));
            }
            if (!resolver.canResolve(element, BaseURI, storage)) continue;
            return resolver;
        }
        Object[] exArgs = new Object[]{element != null && element.getNodeType() == 1 ? element.getTagName() : "null"};
        throw new KeyResolverException("utils.resolver.noClass", exArgs);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new Vector(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        _resolverVector.add(new KeyResolver(className));
    }

    public static void registerAtStart(String className) {
        _resolverVector.add(0, className);
    }

    public static PublicKey resolveStatic(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        KeyResolver myResolver = KeyResolver.getInstance(element, BaseURI, storage);
        return myResolver.resolvePublicKey(element, BaseURI, storage);
    }

    public PublicKey resolvePublicKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineResolvePublicKey(element, BaseURI, storage);
    }

    public X509Certificate resolveX509Certificate(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineResolveX509Certificate(element, BaseURI, storage);
    }

    public SecretKey resolveSecretKey(Element element, String BaseURI, StorageResolver storage) throws KeyResolverException {
        return this._resolverSpi.engineResolveSecretKey(element, BaseURI, storage);
    }

    public void setProperty(String key, String value) {
        this._resolverSpi.engineSetProperty(key, value);
    }

    public String getProperty(String key) {
        return this._resolverSpi.engineGetProperty(key);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String propertyToTest) {
        return this._resolverSpi.understandsProperty(propertyToTest);
    }

    public boolean canResolve(Element element, String BaseURI, StorageResolver storage) {
        return this._resolverSpi.engineCanResolve(element, BaseURI, storage);
    }

    public String resolverClassName() {
        return this._resolverSpi.getClass().getName();
    }
}

