/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content;

import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.KeyInfoContent;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyValue
extends SignatureElementProxy
implements KeyInfoContent {
    static Log log = LogFactory.getLog((String)KeyValue.class.getName());

    public KeyValue(Document doc, DSAKeyValue dsaKeyValue) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(dsaKeyValue.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyValue(Document doc, RSAKeyValue rsaKeyValue) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(rsaKeyValue.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyValue(Document doc, Element unknownKeyValue) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._constructionElement.appendChild(unknownKeyValue);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyValue(Document doc, PublicKey pk) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (pk instanceof DSAPublicKey) {
            DSAKeyValue dsa = new DSAKeyValue(this._doc, pk);
            this._constructionElement.appendChild(dsa.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        } else if (pk instanceof RSAPublicKey) {
            RSAKeyValue rsa = new RSAKeyValue(this._doc, pk);
            this._constructionElement.appendChild(rsa.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
    }

    public KeyValue(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        Element rsa = XMLUtils.selectDsNode(this._constructionElement, "RSAKeyValue", 0);
        if (rsa != null) {
            RSAKeyValue kv = new RSAKeyValue(rsa, this._baseURI);
            return kv.getPublicKey();
        }
        Element dsa = XMLUtils.selectDsNode(this._constructionElement, "DSAKeyValue", 0);
        if (dsa != null) {
            DSAKeyValue kv = new DSAKeyValue(dsa, this._baseURI);
            return kv.getPublicKey();
        }
        return null;
    }

    public String getBaseLocalName() {
        return "KeyValue";
    }
}

