/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.helper.AttrCompare;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.apache.xml.security.utils.UnsyncByteArrayOutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    private static final byte[] _END_PI = new byte[]{63, 62};
    private static final byte[] _BEGIN_PI = new byte[]{60, 63};
    private static final byte[] _END_COMM = new byte[]{45, 45, 62};
    private static final byte[] _BEGIN_COMM = new byte[]{60, 33, 45, 45};
    private static final byte[] __XA_ = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] __X9_ = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] _QUOT_ = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] __XD_ = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] _GT_ = new byte[]{38, 103, 116, 59};
    private static final byte[] _LT_ = new byte[]{38, 108, 116, 59};
    private static final byte[] _END_TAG = new byte[]{60, 47};
    private static final byte[] _AMP_ = new byte[]{38, 97, 109, 112, 59};
    static final AttrCompare COMPARE = new AttrCompare();
    static final String XML = "xml";
    static final String XMLNS = "xmlns";
    static final byte[] equalsStr = new byte[]{61, 34};
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    protected static final Attr nullNode;
    boolean _includeComments;
    Set _xpathNodeSet = null;
    Node _excludeNode = null;
    OutputStream _writer = new UnsyncByteArrayOutputStream();

    public CanonicalizerBase(boolean includeComments) {
        this._includeComments = includeComments;
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, (Node)null);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, Node excludeNode) throws CanonicalizationException {
        this._excludeNode = excludeNode;
        try {
            NameSpaceSymbTable ns = new NameSpaceSymbTable();
            if (rootNode instanceof Element) {
                CanonicalizerBase.getParentNameSpaces((Element)rootNode, ns);
            }
            this.canonicalizeSubTree(rootNode, ns);
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] result = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return result;
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }

    final void canonicalizeSubTree(Node currentNode, NameSpaceSymbTable ns) throws CanonicalizationException, IOException {
        switch (currentNode.getNodeType()) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node currentChild = currentNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                    this.canonicalizeSubTree(currentChild, ns);
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                CanonicalizerBase.outputCommentToWriter((Comment)currentNode, this._writer);
                break;
            }
            case 7: {
                CanonicalizerBase.outputPItoWriter((ProcessingInstruction)currentNode, this._writer);
                break;
            }
            case 3: 
            case 4: {
                CanonicalizerBase.outputTextToWriter(currentNode.getNodeValue(), this._writer);
                break;
            }
            case 1: {
                if (currentNode == this._excludeNode) {
                    return;
                }
                OutputStream writer = this._writer;
                Element currentElement = (Element)currentNode;
                ns.outputNodePush();
                writer.write(60);
                String tagName = currentElement.getTagName();
                CanonicalizerBase.writeStringToUtf8(tagName, writer);
                Iterator attrs = this.handleAttributesSubtree(currentElement, ns);
                if (attrs != null) {
                    while (attrs.hasNext()) {
                        Attr attr = (Attr)attrs.next();
                        CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), writer);
                    }
                }
                writer.write(62);
                for (Node currentChild = currentNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                    this.canonicalizeSubTree(currentChild, ns);
                }
                writer.write(_END_TAG);
                CanonicalizerBase.writeStringToUtf8(tagName, writer);
                writer.write(62);
                ns.outputNodePop();
            }
        }
    }

    static final int getPositionRelativeToDocumentElement(Node currentNode) {
        if (currentNode == null || currentNode.getParentNode().getNodeType() != 9) {
            return 0;
        }
        Element documentElement = currentNode.getOwnerDocument().getDocumentElement();
        if (documentElement == null || documentElement == currentNode) {
            return 0;
        }
        for (Node x = currentNode; x != null; x = x.getNextSibling()) {
            if (x != documentElement) continue;
            return -1;
        }
        return 1;
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet) throws CanonicalizationException {
        if (xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        this._xpathNodeSet = xpathNodeSet;
        try {
            Document rootNodeOfC14n = XMLUtils.getOwnerDocument(this._xpathNodeSet);
            this.canonicalizeXPathNodeSet(rootNodeOfC14n, new NameSpaceSymbTable());
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] sol = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return sol;
            }
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            throw new CanonicalizationException("empty", ex);
        }
        catch (IOException ex) {
            throw new CanonicalizationException("empty", ex);
        }
    }

    final void canonicalizeXPathNodeSet(Node currentNode, NameSpaceSymbTable ns) throws CanonicalizationException, IOException {
        boolean currentNodeIsVisible = this._xpathNodeSet.contains(currentNode);
        switch (currentNode.getNodeType()) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node currentChild = currentNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(currentChild, ns);
                }
                break;
            }
            case 8: {
                if (!currentNodeIsVisible || !this._includeComments) break;
                CanonicalizerBase.outputCommentToWriter((Comment)currentNode, this._writer);
                break;
            }
            case 7: {
                if (!currentNodeIsVisible) break;
                CanonicalizerBase.outputPItoWriter((ProcessingInstruction)currentNode, this._writer);
                break;
            }
            case 3: 
            case 4: {
                if (!currentNodeIsVisible) break;
                CanonicalizerBase.outputTextToWriter(currentNode.getNodeValue(), this._writer);
                for (Node nextSibling = currentNode.getNextSibling(); nextSibling != null && (nextSibling.getNodeType() == 3 || nextSibling.getNodeType() == 4); nextSibling = nextSibling.getNextSibling()) {
                    CanonicalizerBase.outputTextToWriter(nextSibling.getNodeValue(), this._writer);
                }
                break;
            }
            case 1: {
                Element currentElement = (Element)currentNode;
                OutputStream writer = this._writer;
                String tagName = currentElement.getTagName();
                if (currentNodeIsVisible) {
                    ns.outputNodePush();
                    writer.write(60);
                    CanonicalizerBase.writeStringToUtf8(tagName, writer);
                } else {
                    ns.push();
                }
                Iterator attrs = this.handleAttributes(currentElement, ns);
                while (attrs.hasNext()) {
                    Attr attr = (Attr)attrs.next();
                    CanonicalizerBase.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue(), writer);
                }
                if (currentNodeIsVisible) {
                    writer.write(62);
                }
                for (Node currentChild = currentNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(currentChild, ns);
                }
                if (currentNodeIsVisible) {
                    writer.write(_END_TAG);
                    CanonicalizerBase.writeStringToUtf8(tagName, writer);
                    writer.write(62);
                    ns.outputNodePop();
                    break;
                }
                ns.pop();
            }
        }
    }

    static final void getParentNameSpaces(Element el, NameSpaceSymbTable ns) {
        ArrayList<Element> parents = new ArrayList<Element>();
        Node n1 = el.getParentNode();
        if (!(n1 instanceof Element)) {
            return;
        }
        Element parent = (Element)el.getParentNode();
        while (parent != null) {
            parents.add(parent);
            Node n = parent.getParentNode();
            if (!(n instanceof Element)) break;
            parent = (Element)n;
        }
        ListIterator it = parents.listIterator(parents.size());
        while (it.hasPrevious()) {
            Element ele = (Element)it.previous();
            if (!ele.hasAttributes()) continue;
            NamedNodeMap attrs = ele.getAttributes();
            int attrsLength = attrs.getLength();
            for (int i = 0; i < attrsLength; ++i) {
                Attr N = (Attr)attrs.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(N.getNamespaceURI())) continue;
                String NName = N.getLocalName();
                String NValue = N.getNodeValue();
                if (XML.equals(NName) && "http://www.w3.org/XML/1998/namespace".equals(NValue)) continue;
                ns.addMapping(NName, NValue, N);
            }
        }
        Attr nsprefix = ns.getMappingWithoutRendered(XMLNS);
        if (nsprefix != null && "".equals(nsprefix.getValue())) {
            ns.addMappingAndRender(XMLNS, "", nullNode);
        }
    }

    static final void outputAttrToWriter(String name, String value, OutputStream writer) throws IOException {
        writer.write(32);
        CanonicalizerBase.writeStringToUtf8(name, writer);
        writer.write(equalsStr);
        int length = value.length();
        block8: for (int i = 0; i < length; ++i) {
            byte[] toWrite;
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    toWrite = _LT_;
                    break;
                }
                case '\"': {
                    toWrite = _QUOT_;
                    break;
                }
                case '\t': {
                    toWrite = __X9_;
                    break;
                }
                case '\n': {
                    toWrite = __XA_;
                    break;
                }
                case '\r': {
                    toWrite = __XD_;
                    break;
                }
                default: {
                    CanonicalizerBase.writeCharToUtf8(c, writer);
                    continue block8;
                }
            }
            writer.write(toWrite);
        }
        writer.write(34);
    }

    static final void writeCharToUtf8(char c, OutputStream out) throws IOException {
        if (c <= '\u007f') {
            out.write(c);
            return;
        }
        if (c > '\u07ff') {
            char ch = (char)(c >>> 12);
            if (ch > '\u0000') {
                out.write(0xE0 | ch & 0xF);
            } else {
                out.write(224);
            }
            out.write(0x80 | c >>> 6 & 0x3F);
            out.write(0x80 | c & 0x3F);
            return;
        }
        char ch = (char)(c >>> 6);
        if (ch > '\u0000') {
            out.write(0xC0 | ch & 0x1F);
        } else {
            out.write(192);
        }
        out.write(0x80 | c & 0x3F);
    }

    static final void writeStringToUtf8(String str, OutputStream out) throws IOException {
        int length = str.length();
        int i = 0;
        while (i < length) {
            char ch;
            char c;
            if ((c = str.charAt(i++)) <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                ch = (char)(c >>> 12);
                if (ch > '\u0000') {
                    out.write(0xE0 | ch & 0xF);
                } else {
                    out.write(224);
                }
                out.write(0x80 | c >>> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
                continue;
            }
            ch = (char)(c >>> 6);
            if (ch > '\u0000') {
                out.write(0xC0 | ch & 0x1F);
            } else {
                out.write(192);
            }
            out.write(0x80 | c & 0x3F);
        }
    }

    static final void outputPItoWriter(ProcessingInstruction currentPI, OutputStream writer) throws IOException {
        int position = CanonicalizerBase.getPositionRelativeToDocumentElement(currentPI);
        if (position == 1) {
            writer.write(10);
        }
        writer.write(_BEGIN_PI);
        String target = currentPI.getTarget();
        int length = target.length();
        for (int i = 0; i < length; ++i) {
            char c = target.charAt(i);
            if (c == '\r') {
                writer.write(__XD_);
                continue;
            }
            CanonicalizerBase.writeCharToUtf8(c, writer);
        }
        String data = currentPI.getData();
        length = data.length();
        if (length > 0) {
            writer.write(32);
            for (int i = 0; i < length; ++i) {
                char c = data.charAt(i);
                if (c == '\r') {
                    writer.write(__XD_);
                    continue;
                }
                CanonicalizerBase.writeCharToUtf8(c, writer);
            }
        }
        writer.write(_END_PI);
        if (position == -1) {
            writer.write(10);
        }
    }

    static final void outputCommentToWriter(Comment currentComment, OutputStream writer) throws IOException {
        int position = CanonicalizerBase.getPositionRelativeToDocumentElement(currentComment);
        if (position == 1) {
            writer.write(10);
        }
        writer.write(_BEGIN_COMM);
        String data = currentComment.getData();
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(i);
            if (c == '\r') {
                writer.write(__XD_);
                continue;
            }
            CanonicalizerBase.writeCharToUtf8(c, writer);
        }
        writer.write(_END_COMM);
        if (position == -1) {
            writer.write(10);
        }
    }

    static final void outputTextToWriter(String text, OutputStream writer) throws IOException {
        int length = text.length();
        block6: for (int i = 0; i < length; ++i) {
            byte[] toWrite;
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    toWrite = _LT_;
                    break;
                }
                case '>': {
                    toWrite = _GT_;
                    break;
                }
                case '\r': {
                    toWrite = __XD_;
                    break;
                }
                default: {
                    CanonicalizerBase.writeCharToUtf8(c, writer);
                    continue block6;
                }
            }
            writer.write(toWrite);
        }
    }

    abstract Iterator handleAttributes(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract Iterator handleAttributesSubtree(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    public final boolean is_includeComments() {
        return this._includeComments;
    }

    public final void set_includeComments(boolean comments) {
        this._includeComments = comments;
    }

    public void setWriter(OutputStream _writer) {
        this._writer = _writer;
    }

    static {
        try {
            nullNode = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS);
            nullNode.setValue("");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create nullNode" + e);
        }
    }
}

