/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.implementations.CanonicalizerBase;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class Canonicalizer20010315Excl
extends CanonicalizerBase {
    TreeSet _inclusiveNSSet = null;
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    public Canonicalizer20010315Excl(boolean includeComments) {
        super(includeComments);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, "", null);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(rootNode, inclusiveNamespaces, null);
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces, Node excl) throws CanonicalizationException {
        this._inclusiveNSSet = (TreeSet)InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces);
        return super.engineCanonicalizeSubTree(rootNode, excl);
    }

    Iterator handleAttributesSubtree(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        TreeSet<Attr> result = new TreeSet<Attr>(COMPARE);
        NamedNodeMap attrs = null;
        int attrsLength = 0;
        if (E.hasAttributes()) {
            attrs = E.getAttributes();
            attrsLength = attrs.getLength();
        }
        SortedSet visiblyUtilized = (SortedSet)this._inclusiveNSSet.clone();
        for (int i = 0; i < attrsLength; ++i) {
            Attr N = (Attr)attrs.item(i);
            String NName = N.getLocalName();
            String NNodeValue = N.getNodeValue();
            if (!XMLNS_URI.equals(N.getNamespaceURI())) {
                String prefix = N.getPrefix();
                if (prefix != null && !prefix.equals("xml") && !prefix.equals("xmlns")) {
                    visiblyUtilized.add(prefix);
                }
                result.add(N);
                continue;
            }
            if (!ns.addMapping(NName, NNodeValue, N) || !C14nHelper.namespaceIsRelative(NNodeValue)) continue;
            Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
        if (E.getNamespaceURI() != null) {
            String prefix = E.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                visiblyUtilized.add("xmlns");
            } else {
                visiblyUtilized.add(prefix);
            }
        } else {
            visiblyUtilized.add("xmlns");
        }
        Iterator it = visiblyUtilized.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            Attr key = ns.getMapping(s);
            if (key == null) continue;
            result.add(key);
        }
        return result.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet, String inclusiveNamespaces) throws CanonicalizationException {
        try {
            this._inclusiveNSSet = (TreeSet)InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces);
            byte[] byArray = super.engineCanonicalizeXPathNodeSet(xpathNodeSet);
            return byArray;
        }
        finally {
            this._inclusiveNSSet = null;
        }
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet) throws CanonicalizationException {
        return this.engineCanonicalizeXPathNodeSet(xpathNodeSet, "");
    }

    final Iterator handleAttributes(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        TreeSet<Attr> result = new TreeSet<Attr>(COMPARE);
        NamedNodeMap attrs = null;
        int attrsLength = 0;
        if (E.hasAttributes()) {
            attrs = E.getAttributes();
            attrsLength = attrs.getLength();
        }
        Set visiblyUtilized = null;
        boolean isOutputElement = this._xpathNodeSet.contains(E);
        if (isOutputElement) {
            visiblyUtilized = (Set)this._inclusiveNSSet.clone();
        }
        for (int i = 0; i < attrsLength; ++i) {
            Attr N = (Attr)attrs.item(i);
            String NName = N.getLocalName();
            String NNodeValue = N.getNodeValue();
            if (!this._xpathNodeSet.contains(N)) continue;
            if (!XMLNS_URI.equals(N.getNamespaceURI())) {
                if (!isOutputElement) continue;
                String prefix = N.getPrefix();
                if (prefix != null && !prefix.equals("xml") && !prefix.equals("xmlns")) {
                    visiblyUtilized.add(prefix);
                }
                result.add(N);
                continue;
            }
            if (!ns.addMapping(NName, NNodeValue, N) || !C14nHelper.namespaceIsRelative(NNodeValue)) continue;
            Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
        if (isOutputElement) {
            Attr xmlns = E.getAttributeNodeNS(XMLNS_URI, "xmlns");
            if (xmlns != null && !this._xpathNodeSet.contains(xmlns)) {
                ns.addMapping("xmlns", "", nullNode);
            }
            if (E.getNamespaceURI() != null) {
                String prefix = E.getPrefix();
                if (prefix == null || prefix.length() == 0) {
                    visiblyUtilized.add("xmlns");
                } else {
                    visiblyUtilized.add(prefix);
                }
            } else {
                visiblyUtilized.add("xmlns");
            }
            Iterator it = visiblyUtilized.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                Attr key = ns.getMapping(s);
                if (key == null) continue;
                result.add(key);
            }
        } else {
            Iterator it = this._inclusiveNSSet.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                Attr key = ns.getMappingWithoutRendered(s);
                if (key == null) continue;
                result.add(key);
            }
        }
        return result.iterator();
    }
}

