/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.c14n.implementations.CanonicalizerBase;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class Canonicalizer20010315
extends CanonicalizerBase {
    boolean firstCall = true;
    static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";

    public Canonicalizer20010315(boolean includeComments) {
        super(includeComments);
    }

    Iterator handleAttributesSubtree(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        if (!E.hasAttributes() && !this.firstCall) {
            return null;
        }
        TreeSet<Node> result = new TreeSet<Node>(COMPARE);
        NamedNodeMap attrs = E.getAttributes();
        int attrsLength = attrs.getLength();
        for (int i = 0; i < attrsLength; ++i) {
            Node n;
            Attr N = (Attr)attrs.item(i);
            String NName = N.getLocalName();
            String NValue = N.getValue();
            String NUri = N.getNamespaceURI();
            if (!XMLNS_URI.equals(NUri)) {
                result.add(N);
                continue;
            }
            if ("xml".equals(NName) && XML_LANG_URI.equals(NValue) || (n = ns.addMappingAndRender(NName, NValue, N)) == null) continue;
            result.add(n);
            if (!C14nHelper.namespaceIsRelative(N)) continue;
            Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
        if (this.firstCall) {
            ns.getUnrenderedNodes(result);
            this.addXmlAttributesSubtree(E, result);
            this.firstCall = false;
        }
        return result.iterator();
    }

    private void addXmlAttributesSubtree(Element E, SortedSet result) {
        Node parent = E.getParentNode();
        HashMap<String, Attr> loa = new HashMap<String, Attr>();
        if (parent != null && parent.getNodeType() == 1) {
            for (Node ancestor = parent; ancestor != null && ancestor.getNodeType() == 1; ancestor = ancestor.getParentNode()) {
                Element el = (Element)ancestor;
                if (!el.hasAttributes()) continue;
                NamedNodeMap ancestorAttrs = el.getAttributes();
                for (int i = 0; i < ancestorAttrs.getLength(); ++i) {
                    Attr currentAncestorAttr = (Attr)ancestorAttrs.item(i);
                    if (!XML_LANG_URI.equals(currentAncestorAttr.getNamespaceURI()) || E.hasAttributeNS(XML_LANG_URI, currentAncestorAttr.getLocalName()) || loa.containsKey(currentAncestorAttr.getName())) continue;
                    loa.put(currentAncestorAttr.getName(), currentAncestorAttr);
                }
            }
        }
        result.addAll(loa.values());
    }

    Iterator handleAttributes(Element E, NameSpaceSymbTable ns) throws CanonicalizationException {
        boolean isRealVisible = this._xpathNodeSet.contains(E);
        NamedNodeMap attrs = null;
        int attrsLength = 0;
        if (E.hasAttributes()) {
            attrs = E.getAttributes();
            attrsLength = attrs.getLength();
        }
        TreeSet<Node> result = new TreeSet<Node>(COMPARE);
        for (int i = 0; i < attrsLength; ++i) {
            Node n;
            Attr N = (Attr)attrs.item(i);
            String NName = N.getLocalName();
            String NValue = N.getValue();
            String NUri = N.getNamespaceURI();
            if (!XMLNS_URI.equals(NUri)) {
                if (!isRealVisible) continue;
                result.add(N);
                continue;
            }
            if ("xml".equals(NName) && XML_LANG_URI.equals(NValue) || !this._xpathNodeSet.contains(N) || (n = ns.addMappingAndRenderXNodeSet(NName, NValue, N, isRealVisible)) == null) continue;
            result.add(n);
            if (!C14nHelper.namespaceIsRelative(N)) continue;
            Object[] exArgs = new Object[]{E.getTagName(), NName, N.getNodeValue()};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
        if (isRealVisible) {
            Attr xmlns = E.getAttributeNodeNS(XMLNS_URI, "xmlns");
            Node n = null;
            if (xmlns == null) {
                n = ns.getMapping("xmlns");
            } else if (!this._xpathNodeSet.contains(xmlns)) {
                n = ns.addMappingAndRenderXNodeSet("xmlns", "", nullNode, true);
            }
            if (n != null) {
                result.add(n);
            }
            this.addXmlAttributes(E, result);
        }
        return result.iterator();
    }

    private void addXmlAttributes(Element E, SortedSet result) {
        Node parent = E.getParentNode();
        HashMap<String, Attr> loa = new HashMap<String, Attr>();
        if (parent != null && parent.getNodeType() == 1 && !this._xpathNodeSet.contains(parent)) {
            for (Node ancestor = parent; ancestor != null && ancestor.getNodeType() == 1; ancestor = ancestor.getParentNode()) {
                Element el = (Element)ancestor;
                if (!el.hasAttributes()) continue;
                NamedNodeMap ancestorAttrs = el.getAttributes();
                for (int i = 0; i < ancestorAttrs.getLength(); ++i) {
                    Attr currentAncestorAttr = (Attr)ancestorAttrs.item(i);
                    if (!XML_LANG_URI.equals(currentAncestorAttr.getNamespaceURI()) || E.hasAttributeNS(XML_LANG_URI, currentAncestorAttr.getLocalName()) || loa.containsKey(currentAncestorAttr.getName())) continue;
                    loa.put(currentAncestorAttr.getName(), currentAncestorAttr);
                }
            }
        }
        result.addAll(loa.values());
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set xpathNodeSet, String inclusiveNamespaces) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }

    public byte[] engineCanonicalizeSubTree(Node rootNode, String inclusiveNamespaces) throws CanonicalizationException {
        throw new CanonicalizationException("c14n.Canonicalizer.UnsupportedOperation");
    }
}

