/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.icao;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.icao.DataGroupHash;
import org.bouncycastle.asn1.icao.ICAOObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class LDSSecurityObject
extends ASN1Encodable
implements ICAOObjectIdentifiers {
    public static final int ub_DataGroups = 16;
    DERInteger version = new DERInteger(0);
    AlgorithmIdentifier digestAlgorithmIdentifier;
    DataGroupHash[] datagroupHash;

    public static LDSSecurityObject getInstance(Object object) {
        if (object == null || object instanceof LDSSecurityObject) {
            return (LDSSecurityObject)object;
        }
        if (object instanceof ASN1Sequence) {
            return new LDSSecurityObject(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public LDSSecurityObject(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence == null || aSN1Sequence.size() == 0) {
            throw new IllegalArgumentException("null or empty sequence passed.");
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = DERInteger.getInstance(enumeration.nextElement());
        this.digestAlgorithmIdentifier = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance(enumeration.nextElement());
        this.checkDatagroupHashSeqSize(aSN1Sequence2.size());
        this.datagroupHash = new DataGroupHash[aSN1Sequence2.size()];
        int n = 0;
        while (n < aSN1Sequence2.size()) {
            this.datagroupHash[n] = DataGroupHash.getInstance(aSN1Sequence2.getObjectAt(n));
            ++n;
        }
    }

    public LDSSecurityObject(AlgorithmIdentifier algorithmIdentifier, DataGroupHash[] dataGroupHashArray) {
        this.digestAlgorithmIdentifier = algorithmIdentifier;
        this.datagroupHash = dataGroupHashArray;
        this.checkDatagroupHashSeqSize(dataGroupHashArray.length);
    }

    private void checkDatagroupHashSeqSize(int n) {
        if (n < 2 || n > 16) {
            throw new IllegalArgumentException("wrong size in DataGroupHashValues : not in (2..16)");
        }
    }

    public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
        return this.digestAlgorithmIdentifier;
    }

    public DataGroupHash[] getDatagroupHash() {
        return this.datagroupHash;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.digestAlgorithmIdentifier);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        int n = 0;
        while (n < this.datagroupHash.length) {
            aSN1EncodableVector2.add(this.datagroupHash[n]);
            ++n;
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        return new DERSequence(aSN1EncodableVector);
    }
}

