/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.w3c.dom.Element;

public abstract class SAMLSubjectQuery
extends SAMLQuery
implements Cloneable {
    protected SAMLSubject subject = null;

    public SAMLSubjectQuery() {
    }

    public SAMLSubjectQuery(SAMLSubject sAMLSubject) throws SAMLException {
        this.subject = sAMLSubject;
    }

    public SAMLSubjectQuery(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLSubjectQuery(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLSubjectQuery.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        this.subject = new SAMLSubject(XML.getFirstChildElement(element));
    }

    public SAMLSubject getSubject() {
        return this.subject;
    }

    public void setSubject(SAMLSubject sAMLSubject) throws SAMLException {
        if (sAMLSubject != null) {
            if (this.root != null) {
                this.root.replaceChild(sAMLSubject.toDOM(this.root.getOwnerDocument()), this.subject.root);
            }
        } else {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.subject = sAMLSubject;
    }

    public void checkValidity() throws SAMLException {
        if (this.subject == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SubjectQuery invalid, requires subject");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLSubjectQuery sAMLSubjectQuery = (SAMLSubjectQuery)super.clone();
        sAMLSubjectQuery.subject = (SAMLSubject)this.subject.clone();
        return sAMLSubjectQuery;
    }
}

