/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAction
extends SAMLObject
implements Cloneable {
    public static final String SAML_ACTION_NAMESPACE_RWEDC = "urn:oasis:names:tc:SAML:1.0:action:rwedc";
    public static final String SAML_ACTION_NAMESPACE_RWEDC_NEG = "urn:oasis:names:tc:SAML:1.0:action:rwedc-negation";
    public static final String SAML_ACTION_NAMESPACE_GHPP = "urn:oasis:names:tc:SAML:1.0:action:ghpp";
    public static final String SAML_ACTION_NAMESPACE_UNIX = "urn:oasis:names:tc:SAML:1.0:action:unix";
    private String namespace = null;
    private String data = null;

    public SAMLAction() {
    }

    public SAMLAction(String string, String string2) throws SAMLException {
        this.namespace = string;
        this.data = string2;
    }

    public SAMLAction(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAction(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAction.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "Action")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAction() requires saml:Action at root");
        }
        this.namespace = element.getAttributeNS(null, "Namespace");
        this.data = element.getFirstChild().getNodeValue();
        this.checkValidity();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getData() {
        return this.data;
    }

    public void setNamespace(String string) {
        if (this.root != null) {
            if (!XML.isEmpty(string)) {
                ((Element)this.root).setAttributeNS(null, "Namespace", string);
            } else if (!XML.isEmpty(this.namespace)) {
                ((Element)this.root).removeAttributeNS(null, "Namespace");
            }
        }
        this.namespace = string;
    }

    public void setData(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("data cannot be null or empty");
        }
        this.data = string;
        if (this.root != null) {
            this.root.getFirstChild().setNodeValue(string);
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Action");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        if (!XML.isEmpty(this.namespace)) {
            element.setAttributeNS(null, "Namespace", this.namespace);
        }
        element.appendChild(document.createTextNode(this.data));
        this.root = element;
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.data)) {
            throw new MalformedException("Action is invalid, data must have a value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

