/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.opensaml.util.storage.ExpiringObject;
import org.opensaml.util.storage.StorageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringObjectStorageServiceSweeper
extends TimerTask {
    private StorageService store;
    private Set<String> partitions;

    public ExpiringObjectStorageServiceSweeper(Timer taskTimer, long sweepInterval, StorageService sweptStore) {
        this.store = sweptStore;
        taskTimer.schedule((TimerTask)this, sweepInterval);
    }

    public ExpiringObjectStorageServiceSweeper(Timer taskTimer, long sweepInterval, StorageService sweptStore, Set<String> sweptParitions) {
        this.store = sweptStore;
        if (sweptParitions != null || sweptParitions.isEmpty()) {
            this.partitions = sweptParitions;
        }
        taskTimer.schedule((TimerTask)this, sweepInterval);
    }

    @Override
    public void run() {
        Iterator<String> sweepPartitions = this.partitions != null ? this.partitions.iterator() : this.store.getPartitions();
        while (sweepPartitions.hasNext()) {
            String currentParition = sweepPartitions.next();
            Iterator partitionKeys = this.store.getKeys(currentParition);
            if (partitionKeys == null) continue;
            while (partitionKeys.hasNext()) {
                Object partitionKey = partitionKeys.next();
                Object partitionValue = this.store.get(currentParition, partitionKey);
                if (!(partitionValue instanceof ExpiringObject) || !((ExpiringObject)partitionValue).isExpired()) continue;
                partitionKeys.remove();
            }
        }
    }
}

