/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortKeyEvaluator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathEvaluator;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression,
SortKeyEvaluator {
    private Configuration config;
    private Executable executable;
    private Expression expression;
    private NodeInfo contextNode;
    private SlotManager stackFrameMap;
    private XPathExpressionImpl sortKey = null;

    protected XPathExpressionImpl(Expression expression, Executable executable) {
        this.expression = expression;
        this.executable = executable;
        this.config = executable.getConfiguration();
    }

    protected void setStackFrameMap(SlotManager slotManager) {
        this.stackFrameMap = slotManager;
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSortKey(XPathExpressionImpl xPathExpressionImpl) {
        this.sortKey = xPathExpressionImpl;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        if (nodeInfo.getConfiguration() != this.config) {
            throw new IllegalArgumentException("Supplied node uses the wrong Configuration");
        }
        this.contextNode = nodeInfo;
    }

    public List evaluate() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor((Item)this.contextNode, this.executable);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate((XPathContext)xPathContextMajor);
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        return (List)sequenceExtent.convertToJava(Object.class, (XPathContext)xPathContextMajor);
    }

    public Object evaluateSingle() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor((Item)this.contextNode, this.executable);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate((XPathContext)xPathContextMajor);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return Value.convert((Item)item);
    }

    public SequenceIterator rawIterator() throws XPathException {
        XPathContextMajor xPathContextMajor = new XPathContextMajor((Item)this.contextNode, this.executable);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        SequenceIterator sequenceIterator = this.expression.iterate((XPathContext)xPathContextMajor);
        if (this.sortKey != null) {
            Expression expression = this.sortKey.expression;
            if (expression.getItemType(this.config.getTypeHierarchy()) instanceof NodeTest) {
                this.sortKey.expression = new Atomizer(expression, this.config);
            }
            SortKeyDefinition sortKeyDefinition = new SortKeyDefinition();
            sortKeyDefinition = new SortKeyDefinition();
            sortKeyDefinition.setSortKey(this.sortKey.expression);
            AtomicComparer atomicComparer = sortKeyDefinition.makeComparator((XPathContext)xPathContextMajor);
            AtomicComparer[] atomicComparerArray = new AtomicComparer[]{atomicComparer};
            sequenceIterator = new SortedIterator((XPathContext)xPathContextMajor, sequenceIterator, (SortKeyEvaluator)this, atomicComparerArray);
            ((SortedIterator)sequenceIterator).setHostLanguage(54);
        }
        return sequenceIterator;
    }

    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        NodeInfo nodeInfo;
        XPathContextMajor xPathContextMajor;
        ExternalObjectModel externalObjectModel = null;
        if (object != null) {
            if (object instanceof NodeInfo) {
                this.setContextNode((NodeInfo)object);
            } else {
                externalObjectModel = this.config.findExternalObjectModel(object);
                if (externalObjectModel == null) {
                    throw new XPathExpressionException("Cannot locate an object model implementation for nodes of class " + object.getClass().getName());
                }
                xPathContextMajor = externalObjectModel.wrapDocument(object, "", this.config);
                nodeInfo = externalObjectModel.wrapNode((DocumentInfo)xPathContextMajor, object);
                this.setContextNode(nodeInfo);
            }
        }
        xPathContextMajor = new XPathContextMajor((Item)this.contextNode, this.executable);
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        try {
            if (qName.equals(XPathConstants.BOOLEAN)) {
                return this.expression.effectiveBooleanValue((XPathContext)xPathContextMajor);
            }
            if (qName.equals(XPathConstants.STRING)) {
                nodeInfo = this.expression.iterate((XPathContext)xPathContextMajor);
                Item item = nodeInfo.next();
                if (item == null) {
                    return "";
                }
                return item.getStringValue();
            }
            if (qName.equals(XPathConstants.NUMBER)) {
                nodeInfo = new Atomizer(this.expression, this.config).iterate((XPathContext)xPathContextMajor);
                Item item = nodeInfo.next();
                if (item == null) {
                    return new Double(Double.NaN);
                }
                if (item instanceof NumericValue) {
                    return new Double(((NumericValue)item).getDoubleValue());
                }
                DoubleValue doubleValue = NumberFn.convert((AtomicValue)((AtomicValue)item));
                return new Double(doubleValue.getDoubleValue());
            }
            if (qName.equals(XPathConstants.NODE)) {
                nodeInfo = this.expression.iterate((XPathContext)xPathContextMajor);
                Item item = nodeInfo.next();
                if (item instanceof VirtualNode) {
                    return ((VirtualNode)item).getUnderlyingNode();
                }
                if (item == null || item instanceof NodeInfo) {
                    return item;
                }
                throw new XPathExpressionException("Expression result is not a node");
            }
            if (qName.equals(XPathConstants.NODESET)) {
                Object object2;
                nodeInfo = this.expression.iterate((XPathContext)xPathContextMajor);
                SequenceExtent sequenceExtent = new SequenceExtent((SequenceIterator)nodeInfo);
                if (externalObjectModel != null && (object2 = externalObjectModel.convertToNodeList(sequenceExtent)) != null) {
                    return object2;
                }
                return sequenceExtent.convertToJava(List.class, (XPathContext)xPathContextMajor);
            }
            throw new IllegalArgumentException("qName: Unknown type for expected result");
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        if (qName == null) {
            throw new NullPointerException("qName");
        }
        try {
            NodeInfo nodeInfo = null;
            if (inputSource == null) {
                nodeInfo = new XPathEvaluator().setSource(new SAXSource(inputSource));
            }
            return this.evaluate(nodeInfo, qName);
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        try {
            NodeInfo nodeInfo = new XPathEvaluator().setSource(new SAXSource(inputSource));
            return (String)this.evaluate(nodeInfo, XPathConstants.STRING);
        }
        catch (XPathException xPathException) {
            throw new XPathExpressionException(xPathException);
        }
    }

    public Item evaluateSortKey(int n, XPathContext xPathContext) throws XPathException {
        return this.sortKey.getInternalExpression().evaluateItem(xPathContext);
    }

    public Expression getInternalExpression() {
        return this.expression;
    }
}

