/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.io;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.NodeCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.PathResolver;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.env.URLResolver;
import org.apache.commons.scxml.io.ModelUpdater;
import org.apache.commons.scxml.model.Action;
import org.apache.commons.scxml.model.Assign;
import org.apache.commons.scxml.model.Cancel;
import org.apache.commons.scxml.model.CustomAction;
import org.apache.commons.scxml.model.Data;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.Else;
import org.apache.commons.scxml.model.ElseIf;
import org.apache.commons.scxml.model.Executable;
import org.apache.commons.scxml.model.Exit;
import org.apache.commons.scxml.model.ExternalContent;
import org.apache.commons.scxml.model.Finalize;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.If;
import org.apache.commons.scxml.model.Initial;
import org.apache.commons.scxml.model.Invoke;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.NamespacePrefixesHolder;
import org.apache.commons.scxml.model.OnEntry;
import org.apache.commons.scxml.model.OnExit;
import org.apache.commons.scxml.model.Parallel;
import org.apache.commons.scxml.model.Param;
import org.apache.commons.scxml.model.PathResolverHolder;
import org.apache.commons.scxml.model.SCXML;
import org.apache.commons.scxml.model.Send;
import org.apache.commons.scxml.model.State;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;
import org.apache.commons.scxml.model.Var;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SCXMLDigester {
    private static final String NAMESPACE_SCXML = "http://www.w3.org/2005/07/scxml";
    private static final String XP_SM = "scxml";
    private static final String XP_SM_ST = "scxml/state";
    private static final String XPU_ST_ST = "!*/state/state";
    private static final String XPU_PAR_ST = "!*/parallel/state";
    private static final String XPU_TR_TAR_ST = "!*/transition/target/state";
    private static final String XPU_ST_PAR = "!*/state/parallel";
    private static final String XPU_IF = "!*/if";
    private static final String XPU_ONEN = "!*/onentry";
    private static final String XPU_ONEX = "!*/onexit";
    private static final String XPU_TR = "!*/transition";
    private static final String XPU_FIN = "!*/finalize";
    private static final String XPF_ONEN = "/onentry";
    private static final String XPF_ONEX = "/onexit";
    private static final String XPF_DM = "/datamodel";
    private static final String XPF_DATA = "/data";
    private static final String XPF_INI = "/initial";
    private static final String XPF_INV = "/invoke";
    private static final String XPF_PRM = "/param";
    private static final String XPF_FIN = "/finalize";
    private static final String XPF_HIST = "/history";
    private static final String XPF_TR = "/transition";
    private static final String XPF_TAR = "/target";
    private static final String XPF_EXT = "/exit";
    private static final String XPF_VAR = "/var";
    private static final String XPF_ASN = "/assign";
    private static final String XPF_LOG = "/log";
    private static final String XPF_SND = "/send";
    private static final String XPF_CAN = "/cancel";
    private static final String XPF_EIF = "/elseif";
    private static final String XPF_ELS = "/else";
    private static final String ERR_NULL_URL = "Cannot parse null URL";
    private static final String ERR_NULL_PATH = "Cannot parse null URL";
    private static final String ERR_NULL_ISRC = "Cannot parse null URL";
    private static final String ERR_DOC_PARSE_FAIL = "Error parsing SCXML document: \"{0}\", with message: \"{1}\"\n";
    private static final String ERR_ISRC_PARSE_FAIL = "Could not parse SCXML InputSource";
    private static final String ERR_PARSER_CFG_DATA = "XML Parser misconfiguration, error registering <data> element rule";
    private static final String ERR_PARSER_CFG_SEND = "XML Parser misconfiguration, error registering <send> element rule";
    private static final String ERR_PARSER_CFG_CUSTOM = "XML Parser misconfiguration, error registering custom action rules";
    private static final String ERR_CUSTOM_ACTION_TYPE = "Custom actions list contained unknown object (not a Commons SCXML Action subtype)";
    private static final String STR_SLASH = "/";
    static /* synthetic */ Class class$org$apache$commons$scxml$model$ExternalContent;

    public static SCXML digest(URL scxmlURL, ErrorHandler errHandler) throws IOException, SAXException, ModelException {
        if (scxmlURL == null) {
            throw new IllegalArgumentException("Cannot parse null URL");
        }
        return SCXMLDigester.digest(scxmlURL, errHandler, null);
    }

    public static SCXML digest(String documentRealPath, ErrorHandler errHandler, PathResolver pathResolver) throws IOException, SAXException, ModelException {
        return SCXMLDigester.digest(documentRealPath, errHandler, pathResolver, null);
    }

    public static SCXML digest(InputSource documentInputSource, ErrorHandler errHandler) throws IOException, SAXException, ModelException {
        if (documentInputSource == null) {
            throw new IllegalArgumentException("Cannot parse null URL");
        }
        return SCXMLDigester.digest(documentInputSource, errHandler, null);
    }

    public static SCXML digest(URL scxmlURL, ErrorHandler errHandler, List customActions) throws IOException, SAXException, ModelException {
        SCXML scxml = null;
        Digester scxmlDigester = SCXMLDigester.newInstance(null, new URLResolver(scxmlURL), customActions);
        scxmlDigester.setErrorHandler(errHandler);
        try {
            scxml = (SCXML)scxmlDigester.parse(scxmlURL.toString());
        }
        catch (RuntimeException rte) {
            MessageFormat msgFormat = new MessageFormat(ERR_DOC_PARSE_FAIL);
            String errMsg = msgFormat.format(new Object[]{String.valueOf(scxmlURL), rte.getMessage()});
            Log log = LogFactory.getLog((Class)SCXMLDigester.class);
            log.error((Object)errMsg, (Throwable)rte);
            throw rte;
        }
        if (scxml != null) {
            ModelUpdater.updateSCXML(scxml);
        }
        scxml.setLegacy(true);
        return scxml;
    }

    public static SCXML digest(String documentRealPath, ErrorHandler errHandler, PathResolver pathResolver, List customActions) throws IOException, SAXException, ModelException {
        if (documentRealPath == null) {
            throw new IllegalArgumentException("Cannot parse null URL");
        }
        SCXML scxml = null;
        Digester scxmlDigester = SCXMLDigester.newInstance(null, pathResolver, customActions);
        scxmlDigester.setErrorHandler(errHandler);
        try {
            scxml = (SCXML)scxmlDigester.parse(documentRealPath);
        }
        catch (RuntimeException rte) {
            MessageFormat msgFormat = new MessageFormat(ERR_DOC_PARSE_FAIL);
            String errMsg = msgFormat.format(new Object[]{documentRealPath, rte.getMessage()});
            Log log = LogFactory.getLog((Class)SCXMLDigester.class);
            log.error((Object)errMsg, (Throwable)rte);
            throw rte;
        }
        if (scxml != null) {
            ModelUpdater.updateSCXML(scxml);
        }
        return scxml;
    }

    public static SCXML digest(InputSource documentInputSource, ErrorHandler errHandler, List customActions) throws IOException, SAXException, ModelException {
        Digester scxmlDigester = SCXMLDigester.newInstance(null, null, customActions);
        scxmlDigester.setErrorHandler(errHandler);
        SCXML scxml = null;
        try {
            scxml = (SCXML)scxmlDigester.parse(documentInputSource);
        }
        catch (RuntimeException rte) {
            Log log = LogFactory.getLog((Class)SCXMLDigester.class);
            log.error((Object)ERR_ISRC_PARSE_FAIL, (Throwable)rte);
            throw rte;
        }
        if (scxml != null) {
            ModelUpdater.updateSCXML(scxml);
        }
        return scxml;
    }

    public static Digester newInstance() {
        return SCXMLDigester.newInstance(null, null, null);
    }

    public static Digester newInstance(PathResolver pr) {
        return SCXMLDigester.newInstance(null, pr, null);
    }

    public static Digester newInstance(SCXML scxml, PathResolver pr) {
        return SCXMLDigester.newInstance(scxml, pr, null);
    }

    public static Digester newInstance(SCXML scxml, PathResolver pr, List customActions) {
        Digester digester = new Digester();
        digester.setNamespaceAware(true);
        digester.setRules(SCXMLDigester.initRules(scxml, pr, customActions));
        return digester;
    }

    public static void updateSCXML(SCXML scxml) throws ModelException {
        ModelUpdater.updateSCXML(scxml);
    }

    private static ExtendedBaseRules initRules(SCXML scxml, PathResolver pr, List customActions) {
        ExtendedBaseRules scxmlRules = new ExtendedBaseRules();
        scxmlRules.setNamespaceURI(NAMESPACE_SCXML);
        scxmlRules.add(XP_SM, new ObjectCreateRule(SCXML.class));
        scxmlRules.add(XP_SM, new SetPropertiesRule());
        SCXMLDigester.addDatamodelRules("scxml/datamodel", scxmlRules, scxml, pr);
        SCXMLDigester.addStateRules(XP_SM_ST, scxmlRules, customActions, scxml, pr, 0);
        scxmlRules.add(XP_SM_ST, new SetNextRule("addState"));
        SCXMLDigester.addStateRules(XPU_ST_ST, scxmlRules, customActions, scxml, pr, 1);
        scxmlRules.add(XPU_ST_ST, new SetNextRule("addChild"));
        SCXMLDigester.addStateRules(XPU_PAR_ST, scxmlRules, customActions, scxml, pr, 1);
        scxmlRules.add(XPU_PAR_ST, new SetNextRule("addState"));
        SCXMLDigester.addStateRules(XPU_TR_TAR_ST, scxmlRules, customActions, scxml, pr, 2);
        scxmlRules.add(XPU_TR_TAR_ST, new SetNextRule("setTarget"));
        SCXMLDigester.addParallelRules(XPU_ST_PAR, scxmlRules, pr, customActions, scxml);
        SCXMLDigester.addIfRules(XPU_IF, scxmlRules, pr, customActions);
        SCXMLDigester.addCustomActionRules(XPU_ONEN, scxmlRules, customActions);
        SCXMLDigester.addCustomActionRules(XPU_ONEX, scxmlRules, customActions);
        SCXMLDigester.addCustomActionRules(XPU_TR, scxmlRules, customActions);
        SCXMLDigester.addCustomActionRules(XPU_IF, scxmlRules, customActions);
        SCXMLDigester.addCustomActionRules(XPU_FIN, scxmlRules, customActions);
        return scxmlRules;
    }

    private static void addStateRules(String xp, ExtendedBaseRules scxmlRules, List customActions, SCXML scxml, PathResolver pr, int parent) {
        scxmlRules.add(xp, new ObjectCreateRule(State.class));
        SCXMLDigester.addStatePropertiesRules(xp, scxmlRules, customActions, pr, scxml);
        SCXMLDigester.addDatamodelRules(xp + XPF_DM, scxmlRules, scxml, pr);
        SCXMLDigester.addInvokeRules(xp + XPF_INV, scxmlRules, customActions, pr, scxml);
        SCXMLDigester.addInitialRules(xp + XPF_INI, scxmlRules, customActions, pr, scxml);
        SCXMLDigester.addHistoryRules(xp + XPF_HIST, scxmlRules, customActions, pr, scxml);
        SCXMLDigester.addParentRule(xp, scxmlRules, parent);
        SCXMLDigester.addTransitionRules(xp + XPF_TR, scxmlRules, "addTransition", pr, customActions);
        SCXMLDigester.addHandlerRules(xp, scxmlRules, pr, customActions);
        scxmlRules.add(xp, new UpdateModelRule(scxml));
    }

    private static void addParallelRules(String xp, ExtendedBaseRules scxmlRules, PathResolver pr, List customActions, SCXML scxml) {
        SCXMLDigester.addSimpleRulesTuple(xp, scxmlRules, Parallel.class, null, null, "setParallel");
        SCXMLDigester.addHandlerRules(xp, scxmlRules, pr, customActions);
        SCXMLDigester.addParentRule(xp, scxmlRules, 1);
        scxmlRules.add(xp, new UpdateModelRule(scxml));
    }

    private static void addStatePropertiesRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, new SetPropertiesRule(new String[]{"id", "final"}, new String[]{"id", "isFinal"}));
        scxmlRules.add(xp, new DigestSrcAttributeRule(scxml, customActions, pr));
    }

    private static void addDatamodelRules(String xp, ExtendedBaseRules scxmlRules, SCXML scxml, PathResolver pr) {
        scxmlRules.add(xp, new ObjectCreateRule(Datamodel.class));
        scxmlRules.add(xp + XPF_DATA, new ObjectCreateRule(Data.class));
        scxmlRules.add(xp + XPF_DATA, new SetPropertiesRule());
        scxmlRules.add(xp + XPF_DATA, new SetCurrentNamespacesRule());
        scxmlRules.add(xp + XPF_DATA, new SetNextRule("addData"));
        try {
            scxmlRules.add(xp + XPF_DATA, new ParseDataRule(pr));
        }
        catch (ParserConfigurationException pce) {
            Log log = LogFactory.getLog((Class)SCXMLDigester.class);
            log.error((Object)ERR_PARSER_CFG_DATA, (Throwable)pce);
        }
        scxmlRules.add(xp, new SetNextRule("setDatamodel"));
    }

    private static void addInvokeRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, new ObjectCreateRule(Invoke.class));
        scxmlRules.add(xp, new SetPropertiesRule());
        scxmlRules.add(xp, new SetCurrentNamespacesRule());
        scxmlRules.add(xp, new SetPathResolverRule(pr));
        scxmlRules.add(xp + XPF_PRM, new ObjectCreateRule(Param.class));
        scxmlRules.add(xp + XPF_PRM, new SetPropertiesRule());
        scxmlRules.add(xp + XPF_PRM, new SetCurrentNamespacesRule());
        scxmlRules.add(xp + XPF_PRM, new SetNextRule("addParam"));
        scxmlRules.add(xp + XPF_FIN, new ObjectCreateRule(Finalize.class));
        scxmlRules.add(xp + XPF_FIN, new UpdateFinalizeRule());
        SCXMLDigester.addActionRules(xp + XPF_FIN, scxmlRules, pr, customActions);
        scxmlRules.add(xp + XPF_FIN, new SetNextRule("setFinalize"));
        scxmlRules.add(xp, new SetNextRule("setInvoke"));
    }

    private static void addInitialRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, new ObjectCreateRule(Initial.class));
        SCXMLDigester.addPseudoStatePropertiesRules(xp, scxmlRules, customActions, pr, scxml);
        scxmlRules.add(xp, new UpdateModelRule(scxml));
        SCXMLDigester.addTransitionRules(xp + XPF_TR, scxmlRules, "setTransition", pr, customActions);
        scxmlRules.add(xp, new SetNextRule("setInitial"));
    }

    private static void addHistoryRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, new ObjectCreateRule(History.class));
        SCXMLDigester.addPseudoStatePropertiesRules(xp, scxmlRules, customActions, pr, scxml);
        scxmlRules.add(xp, new UpdateModelRule(scxml));
        scxmlRules.add(xp, new SetPropertiesRule(new String[]{"type"}, new String[]{"type"}));
        SCXMLDigester.addTransitionRules(xp + XPF_TR, scxmlRules, "setTransition", pr, customActions);
        scxmlRules.add(xp, new SetNextRule("addHistory"));
    }

    private static void addPseudoStatePropertiesRules(String xp, ExtendedBaseRules scxmlRules, List customActions, PathResolver pr, SCXML scxml) {
        scxmlRules.add(xp, new SetPropertiesRule(new String[]{"id"}, new String[]{"id"}));
        scxmlRules.add(xp, new DigestSrcAttributeRule(scxml, customActions, pr));
        SCXMLDigester.addParentRule(xp, scxmlRules, 1);
    }

    private static void addParentRule(String xp, ExtendedBaseRules scxmlRules, final int parent) {
        if (parent < 1) {
            return;
        }
        scxmlRules.add(xp, new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                TransitionTarget t = (TransitionTarget)this.getDigester().peek();
                TransitionTarget p = (TransitionTarget)this.getDigester().peek(parent);
                t.setParent(p);
            }
        });
    }

    private static void addTransitionRules(String xp, ExtendedBaseRules scxmlRules, String setNextMethod, PathResolver pr, List customActions) {
        scxmlRules.add(xp, new ObjectCreateRule(Transition.class));
        scxmlRules.add(xp, new SetPropertiesRule(new String[]{"event", "cond", "target"}, new String[]{"event", "cond", "next"}));
        scxmlRules.add(xp, new SetCurrentNamespacesRule());
        scxmlRules.add(xp + XPF_TAR, new SetPropertiesRule());
        SCXMLDigester.addActionRules(xp, scxmlRules, pr, customActions);
        scxmlRules.add(xp + XPF_EXT, new Rule(){

            public void end(String namespace, String name) {
                Transition t = (Transition)this.getDigester().peek(1);
                State exitState = new State();
                exitState.setFinal(true);
                t.getTargets().add(exitState);
            }
        });
        scxmlRules.add(xp, new SetNextRule(setNextMethod));
    }

    private static void addHandlerRules(String xp, ExtendedBaseRules scxmlRules, PathResolver pr, List customActions) {
        scxmlRules.add(xp + XPF_ONEN, new ObjectCreateRule(OnEntry.class));
        SCXMLDigester.addActionRules(xp + XPF_ONEN, scxmlRules, pr, customActions);
        scxmlRules.add(xp + XPF_ONEN, new SetNextRule("setOnEntry"));
        scxmlRules.add(xp + XPF_ONEX, new ObjectCreateRule(OnExit.class));
        SCXMLDigester.addActionRules(xp + XPF_ONEX, scxmlRules, pr, customActions);
        scxmlRules.add(xp + XPF_ONEX, new SetNextRule("setOnExit"));
    }

    private static void addActionRules(String xp, ExtendedBaseRules scxmlRules, PathResolver pr, List customActions) {
        SCXMLDigester.addActionRulesTuple(xp + XPF_ASN, scxmlRules, Assign.class);
        scxmlRules.add(xp + XPF_ASN, new SetPathResolverRule(pr));
        SCXMLDigester.addActionRulesTuple(xp + XPF_VAR, scxmlRules, Var.class);
        SCXMLDigester.addActionRulesTuple(xp + XPF_LOG, scxmlRules, org.apache.commons.scxml.model.Log.class);
        SCXMLDigester.addSendRulesTuple(xp + XPF_SND, scxmlRules);
        SCXMLDigester.addActionRulesTuple(xp + XPF_CAN, scxmlRules, Cancel.class);
        SCXMLDigester.addActionRulesTuple(xp + XPF_EXT, scxmlRules, Exit.class);
    }

    private static void addCustomActionRules(String xp, ExtendedBaseRules scxmlRules, List customActions) {
        if (customActions == null || customActions.size() == 0) {
            return;
        }
        for (int i = 0; i < customActions.size(); ++i) {
            Object item = customActions.get(i);
            if (item == null || !(item instanceof CustomAction)) {
                Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLDigester == null ? SCXMLDigester.class$("org.apache.commons.scxml.io.SCXMLDigester") : class$org$apache$commons$scxml$io$SCXMLDigester));
                log.warn((Object)ERR_CUSTOM_ACTION_TYPE);
                continue;
            }
            CustomAction ca = (CustomAction)item;
            scxmlRules.setNamespaceURI(ca.getNamespaceURI());
            String xpfLocalName = STR_SLASH + ca.getLocalName();
            Class klass = ca.getActionClass();
            if (SCXMLHelper.implementationOf(klass, class$org$apache$commons$scxml$model$ExternalContent == null ? SCXMLDigester.class$("org.apache.commons.scxml.model.ExternalContent") : class$org$apache$commons$scxml$model$ExternalContent)) {
                SCXMLDigester.addCustomActionRulesTuple(xp + xpfLocalName, scxmlRules, klass, true);
                continue;
            }
            SCXMLDigester.addCustomActionRulesTuple(xp + xpfLocalName, scxmlRules, klass, false);
        }
        scxmlRules.setNamespaceURI(NAMESPACE_SCXML);
    }

    private static void addSendRulesTuple(String xp, ExtendedBaseRules scxmlRules) {
        SCXMLDigester.addActionRulesTuple(xp, scxmlRules, Send.class);
        try {
            scxmlRules.add(xp, new ParseExternalContentRule());
        }
        catch (ParserConfigurationException pce) {
            Log log = LogFactory.getLog((Class)SCXMLDigester.class);
            log.error((Object)ERR_PARSER_CFG_SEND, (Throwable)pce);
        }
    }

    private static void addCustomActionRulesTuple(String xp, ExtendedBaseRules scxmlRules, Class klass, boolean bodyContent) {
        SCXMLDigester.addActionRulesTuple(xp, scxmlRules, klass);
        if (bodyContent) {
            try {
                scxmlRules.add(xp, new ParseExternalContentRule());
            }
            catch (ParserConfigurationException pce) {
                Log log = LogFactory.getLog((Class)SCXMLDigester.class);
                log.error((Object)ERR_PARSER_CFG_CUSTOM, (Throwable)pce);
            }
        }
    }

    private static void addIfRules(String xp, ExtendedBaseRules scxmlRules, PathResolver pr, List customActions) {
        SCXMLDigester.addActionRulesTuple(xp, scxmlRules, If.class);
        SCXMLDigester.addActionRules(xp, scxmlRules, pr, customActions);
        SCXMLDigester.addActionRulesTuple(xp + XPF_EIF, scxmlRules, ElseIf.class);
        SCXMLDigester.addActionRulesTuple(xp + XPF_ELS, scxmlRules, Else.class);
    }

    private static void addActionRulesTuple(String xp, ExtendedBaseRules scxmlRules, Class klass) {
        SCXMLDigester.addSimpleRulesTuple(xp, scxmlRules, klass, null, null, "addAction");
        scxmlRules.add(xp, new SetExecutableParentRule());
        scxmlRules.add(xp, new SetCurrentNamespacesRule());
    }

    private static void addSimpleRulesTuple(String xp, ExtendedBaseRules scxmlRules, Class klass, String[] args, String[] props, String addMethod) {
        scxmlRules.add(xp, new ObjectCreateRule(klass));
        if (args == null) {
            scxmlRules.add(xp, new SetPropertiesRule());
        } else {
            scxmlRules.add(xp, new SetPropertiesRule(args, props));
        }
        scxmlRules.add(xp, new SetNextRule(addMethod));
    }

    private SCXMLDigester() {
    }

    private static class SetCurrentNamespacesRule
    extends Rule {
        private SetCurrentNamespacesRule() {
        }

        public final void begin(String namespace, String name, Attributes attributes) {
            NamespacePrefixesHolder nsHolder = (NamespacePrefixesHolder)this.getDigester().peek();
            nsHolder.setNamespaces(this.getDigester().getCurrentNamespaces());
        }
    }

    public static class UpdateFinalizeRule
    extends Rule {
        public final void begin(String namespace, String name, Attributes attributes) {
            Finalize finalize = (Finalize)this.getDigester().peek();
            TransitionTarget tt = (TransitionTarget)this.getDigester().peek(2);
            finalize.setParent(tt);
        }
    }

    public static class SetPathResolverRule
    extends Rule {
        private PathResolver pr;

        public SetPathResolverRule(PathResolver pr) {
            this.pr = pr;
        }

        public final void begin(String namespace, String name, Attributes attributes) {
            PathResolverHolder prHolder = (PathResolverHolder)this.getDigester().peek();
            prHolder.setPathResolver(this.pr);
        }
    }

    public static class DigestSrcAttributeRule
    extends Rule {
        private PathResolver pr;
        private SCXML root;
        private List customActions;

        public DigestSrcAttributeRule(List customActions, PathResolver pr) {
            this.customActions = customActions;
            this.pr = pr;
        }

        public DigestSrcAttributeRule(SCXML root, List customActions, PathResolver pr) {
            this.root = root;
            this.customActions = customActions;
            this.pr = pr;
        }

        public final void begin(String namespace, String name, Attributes attributes) {
            String path;
            String src = attributes.getValue("src");
            if (SCXMLHelper.isStringEmpty(src)) {
                return;
            }
            Digester digester = this.getDigester();
            SCXML scxml = (SCXML)digester.peek(digester.getCount() - 1);
            SCXML parent = this.root;
            if (parent == null) {
                parent = scxml;
            }
            PathResolver nextpr = null;
            if (this.pr == null) {
                path = src;
            } else {
                path = this.pr.resolvePath(src);
                nextpr = this.pr.getResolver(src);
            }
            String[] fragments = path.split("#", 2);
            String location = fragments[0];
            String fragment = null;
            if (fragments.length > 1) {
                fragment = fragments[1];
            }
            Digester externalSrcDigester = fragment != null ? SCXMLDigester.newInstance(null, nextpr, this.customActions) : SCXMLDigester.newInstance(parent, nextpr, this.customActions);
            SCXML externalSCXML = null;
            try {
                externalSCXML = (SCXML)externalSrcDigester.parse(location);
            }
            catch (Exception e) {
                Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLDigester == null ? (class$org$apache$commons$scxml$io$SCXMLDigester = SCXMLDigester.class$("org.apache.commons.scxml.io.SCXMLDigester")) : class$org$apache$commons$scxml$io$SCXMLDigester));
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (externalSCXML == null) {
                return;
            }
            State s = (State)digester.peek();
            if (fragment == null) {
                Initial ini = new Initial();
                Transition t = new Transition();
                t.setNext(externalSCXML.getInitial());
                ini.setTransition(t);
                s.setInitial(ini);
                Map children = externalSCXML.getChildren();
                Iterator childIter = children.values().iterator();
                while (childIter.hasNext()) {
                    s.addChild((TransitionTarget)childIter.next());
                }
                s.setDatamodel(externalSCXML.getDatamodel());
            } else {
                Object source = externalSCXML.getTargets().get(fragment);
                if (source == null) {
                    Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLDigester == null ? (class$org$apache$commons$scxml$io$SCXMLDigester = SCXMLDigester.class$("org.apache.commons.scxml.io.SCXMLDigester")) : class$org$apache$commons$scxml$io$SCXMLDigester));
                    log.error((Object)("Unknown fragment in <state src=\"" + path + "\">"));
                    return;
                }
                if (source instanceof State) {
                    State include = (State)source;
                    s.setOnEntry(include.getOnEntry());
                    s.setOnExit(include.getOnExit());
                    s.setDatamodel(include.getDatamodel());
                    List histories = include.getHistory();
                    for (int i = 0; i < histories.size(); ++i) {
                        History h = (History)histories.get(i);
                        s.addHistory(h);
                        parent.addTarget(h);
                    }
                    Iterator childIter = include.getChildren().values().iterator();
                    while (childIter.hasNext()) {
                        TransitionTarget tt = (TransitionTarget)childIter.next();
                        s.addChild(tt);
                        parent.addTarget(tt);
                        DigestSrcAttributeRule.addTargets(parent, tt);
                    }
                    s.setInvoke(include.getInvoke());
                    s.setFinal(include.isFinal());
                    if (include.getInitial() != null) {
                        s.setInitial(include.getInitial());
                    }
                    Iterator transIter = include.getTransitionsList().iterator();
                    while (transIter.hasNext()) {
                        s.addTransition((Transition)transIter.next());
                    }
                } else {
                    Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLDigester == null ? (class$org$apache$commons$scxml$io$SCXMLDigester = SCXMLDigester.class$("org.apache.commons.scxml.io.SCXMLDigester")) : class$org$apache$commons$scxml$io$SCXMLDigester));
                    log.error((Object)("Fragment in <state src=\"" + path + "\"> is not a <state> or <final>"));
                }
            }
        }

        private static void addTargets(SCXML parent, TransitionTarget tt) {
            block4: {
                Iterator<Object> childIter;
                block3: {
                    Iterator histIter = tt.getHistory().iterator();
                    while (histIter.hasNext()) {
                        History h = (History)histIter.next();
                        parent.addTarget(h);
                    }
                    if (!(tt instanceof State)) break block3;
                    childIter = ((State)tt).getChildren().values().iterator();
                    while (childIter.hasNext()) {
                        TransitionTarget child = (TransitionTarget)childIter.next();
                        parent.addTarget(child);
                        DigestSrcAttributeRule.addTargets(parent, child);
                    }
                    break block4;
                }
                if (!(tt instanceof Parallel)) break block4;
                childIter = ((Parallel)tt).getChildren().iterator();
                while (childIter.hasNext()) {
                    TransitionTarget child = (TransitionTarget)childIter.next();
                    parent.addTarget(child);
                    DigestSrcAttributeRule.addTargets(parent, child);
                }
            }
        }
    }

    public static class ParseDataRule
    extends NodeCreateRule {
        private PathResolver pr;
        private String src;
        private String expr;
        private Node attrNode;

        public ParseDataRule(PathResolver pr) throws ParserConfigurationException {
            this.pr = pr;
        }

        public final void begin(String namespace, String name, Attributes attributes) throws Exception {
            super.begin(namespace, name, attributes);
            this.src = attributes.getValue("src");
            this.expr = attributes.getValue("expr");
            if (!SCXMLHelper.isStringEmpty(this.src)) {
                String path = null;
                path = this.pr == null ? this.src : this.pr.resolvePath(this.src);
                try {
                    DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = dbFactory.newDocumentBuilder();
                    this.attrNode = db.parse(path);
                }
                catch (Throwable t) {
                    Log log = LogFactory.getLog((Class)(class$org$apache$commons$scxml$io$SCXMLDigester == null ? (class$org$apache$commons$scxml$io$SCXMLDigester = SCXMLDigester.class$("org.apache.commons.scxml.io.SCXMLDigester")) : class$org$apache$commons$scxml$io$SCXMLDigester));
                    log.error((Object)t.getMessage(), t);
                }
                return;
            }
        }

        public final void end(String namespace, String name) {
            Node bodyNode = (Node)this.getDigester().pop();
            Data data = (Data)this.getDigester().peek();
            if (!SCXMLHelper.isStringEmpty(this.src)) {
                data.setNode(this.attrNode);
            } else if (SCXMLHelper.isStringEmpty(this.expr)) {
                data.setNode(bodyNode);
            }
        }
    }

    public static class ParseExternalContentRule
    extends NodeCreateRule {
        public final void end(String namespace, String name) {
            Element bodyElement = (Element)this.getDigester().pop();
            NodeList childNodes = bodyElement.getChildNodes();
            List externalNodes = ((ExternalContent)this.getDigester().peek()).getExternalNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                externalNodes.add(childNodes.item(i));
            }
        }
    }

    public static class SetExecutableParentRule
    extends Rule {
        public final void end(String namespace, String name) {
            Action child = (Action)this.getDigester().peek();
            for (int i = 1; i < this.getDigester().getCount() - 1; ++i) {
                Object ancestor = this.getDigester().peek(i);
                if (!(ancestor instanceof Executable)) continue;
                child.setParent((Executable)ancestor);
                return;
            }
        }
    }

    public static class UpdateModelRule
    extends Rule {
        private SCXML scxml;

        public UpdateModelRule(SCXML scxml) {
            this.scxml = scxml;
        }

        public final void end(String namespace, String name) {
            if (this.scxml == null) {
                this.scxml = (SCXML)this.getDigester().peek(this.getDigester().getCount() - 1);
            }
            TransitionTarget tt = (TransitionTarget)this.getDigester().peek();
            this.scxml.addTarget(tt);
        }
    }
}

