/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.NotificationRegistry;
import org.apache.commons.scxml.SCXMLExecutor;
import org.apache.commons.scxml.SCXMLHelper;
import org.apache.commons.scxml.invoke.Invoker;
import org.apache.commons.scxml.invoke.InvokerException;
import org.apache.commons.scxml.model.Datamodel;
import org.apache.commons.scxml.model.History;
import org.apache.commons.scxml.model.TransitionTarget;

public class SCInstance
implements Serializable {
    private static final long serialVersionUID = 2L;
    private NotificationRegistry notificationRegistry = new NotificationRegistry();
    private Map contexts = Collections.synchronizedMap(new HashMap());
    private Map histories = Collections.synchronizedMap(new HashMap());
    private Map completions;
    private Map invokerClasses = Collections.synchronizedMap(new HashMap());
    private Map invokers = Collections.synchronizedMap(new HashMap());
    private Evaluator evaluator = null;
    private Context rootContext = null;
    private SCXMLExecutor executor;

    SCInstance(SCXMLExecutor executor) {
        this.completions = Collections.synchronizedMap(new HashMap());
        this.executor = executor;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    void setEvaluator(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public Context getRootContext() {
        if (this.rootContext == null && this.evaluator != null) {
            this.rootContext = this.evaluator.newContext(null);
        }
        return this.rootContext;
    }

    void setRootContext(Context context) {
        this.rootContext = context;
    }

    public NotificationRegistry getNotificationRegistry() {
        return this.notificationRegistry;
    }

    void setNotificationRegistry(NotificationRegistry notifRegistry) {
        this.notificationRegistry = notifRegistry;
    }

    public Context getContext(TransitionTarget transitionTarget) {
        Context context = (Context)this.contexts.get(transitionTarget);
        if (context == null) {
            TransitionTarget parent = transitionTarget.getParent();
            context = parent == null ? this.evaluator.newContext(this.getRootContext()) : this.evaluator.newContext(this.getContext(parent));
            Datamodel datamodel = transitionTarget.getDatamodel();
            SCXMLHelper.cloneDatamodel(datamodel, context, this.evaluator, null);
            this.contexts.put(transitionTarget, context);
        }
        return context;
    }

    Context lookupContext(TransitionTarget transitionTarget) {
        return (Context)this.contexts.get(transitionTarget);
    }

    void setContext(TransitionTarget transitionTarget, Context context) {
        this.contexts.put(transitionTarget, context);
    }

    public Set getLastConfiguration(History history) {
        HashSet lastConfiguration = (HashSet)this.histories.get(history);
        if (lastConfiguration == null) {
            lastConfiguration = new HashSet();
            this.histories.put(history, lastConfiguration);
        }
        return lastConfiguration;
    }

    public void setLastConfiguration(History history, Set lc) {
        Set lastConfiguration = this.getLastConfiguration(history);
        lastConfiguration.clear();
        lastConfiguration.addAll(lc);
    }

    public boolean isEmpty(History history) {
        Set lastConfiguration = (Set)this.histories.get(history);
        return lastConfiguration == null || lastConfiguration.isEmpty();
    }

    public void reset(History history) {
        Set lastConfiguration = (Set)this.histories.get(history);
        if (lastConfiguration != null) {
            lastConfiguration.clear();
        }
    }

    public SCXMLExecutor getExecutor() {
        return this.executor;
    }

    void registerInvokerClass(String targettype, Class invokerClass) {
        this.invokerClasses.put(targettype, invokerClass);
    }

    void unregisterInvokerClass(String targettype) {
        this.invokerClasses.remove(targettype);
    }

    public Invoker newInvoker(String targettype) throws InvokerException {
        Class invokerClass = (Class)this.invokerClasses.get(targettype);
        if (invokerClass == null) {
            throw new InvokerException("No Invoker registered for targettype \"" + targettype + "\"");
        }
        Invoker invoker = null;
        try {
            invoker = (Invoker)invokerClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new InvokerException(ie.getMessage(), ie.getCause());
        }
        catch (IllegalAccessException iae) {
            throw new InvokerException(iae.getMessage(), iae.getCause());
        }
        return invoker;
    }

    public Invoker getInvoker(TransitionTarget transitionTarget) {
        return (Invoker)this.invokers.get(transitionTarget);
    }

    public void setInvoker(TransitionTarget transitionTarget, Invoker invoker) {
        this.invokers.put(transitionTarget, invoker);
    }

    public Map getInvokers() {
        return this.invokers;
    }

    public boolean isDone(TransitionTarget transitionTarget) {
        Boolean done = (Boolean)this.completions.get(transitionTarget);
        if (done == null) {
            return false;
        }
        return done;
    }

    public void setDone(TransitionTarget transitionTarget, boolean done) {
        this.completions.put(transitionTarget, done ? Boolean.TRUE : Boolean.FALSE);
    }
}

