/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TlsAddress;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;

public class TDomainAddressFactoryImpl
implements TDomainAddressFactory {
    private static final LogAdapter logger = LogFactory.getLogger(TDomainAddressFactoryImpl.class);

    @Override
    public Address createAddress(OID transportDomain, OctetString address) {
        if (TransportDomains.snmpUDPDomain.equals((Object)transportDomain) || TransportDomains.transportDomainTcpDns.equals((Object)transportDomain) || TransportDomains.transportDomainUdpDns.equals((Object)transportDomain) || TransportDomains.transportDomainUdpIpv4.equals((Object)transportDomain) || TransportDomains.transportDomainTcpIpv4.equals((Object)transportDomain) || TransportDomains.transportDomainUdpIpv6.equals((Object)transportDomain) || TransportDomains.transportDomainTcpIpv6.equals((Object)transportDomain)) {
            Object transportIpAddress = TransportDomains.transportDomainTcpIpv4.equals((Object)transportDomain) || TransportDomains.transportDomainTcpIpv6.equals((Object)transportDomain) || TransportDomains.transportDomainTcpDns.equals((Object)transportDomain) ? new TcpAddress() : new UdpAddress();
            try {
                transportIpAddress.setTransportAddress(address);
            }
            catch (Exception ex) {
                logger.debug((Serializable)((Object)("Invalid TransportAddress format '" + address + "' for domain " + transportDomain)));
                return null;
            }
            return transportIpAddress;
        }
        return null;
    }

    @Override
    public boolean isValidAddress(OID transportDomain, OctetString address) {
        try {
            Address addr = this.createAddress(transportDomain, address);
            if (addr != null) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.debug((Serializable)((Object)("Address is not valid TDomain address: " + address + "; details: " + ex.getMessage())));
        }
        return false;
    }

    @Override
    public OID[] getTransportDomain(Address address) {
        if (address instanceof TransportIpAddress) {
            TransportIpAddress tipaddr = (TransportIpAddress)address;
            if (tipaddr.getInetAddress() instanceof Inet4Address) {
                if (address instanceof UdpAddress) {
                    return new OID[]{TransportDomains.transportDomainUdpIpv4, TransportDomains.transportDomainUdpDns, TransportDomains.snmpUDPDomain};
                }
                if (address instanceof TcpAddress) {
                    return new OID[]{TransportDomains.transportDomainTcpIpv4, TransportDomains.transportDomainTcpDns};
                }
                if (address instanceof TlsAddress) {
                    return new OID[]{TransportDomains.snmpTLSTCPDomain};
                }
            } else if (tipaddr.getInetAddress() instanceof Inet6Address) {
                if (address instanceof UdpAddress) {
                    return new OID[]{TransportDomains.transportDomainUdpIpv6, TransportDomains.transportDomainUdpDns, TransportDomains.snmpUDPDomain};
                }
                if (address instanceof TcpAddress) {
                    return new OID[]{TransportDomains.transportDomainTcpIpv6, TransportDomains.transportDomainTcpDns};
                }
            }
        }
        return null;
    }

    @Override
    public OctetString getAddress(Address address) {
        if (address instanceof TransportIpAddress) {
            TransportIpAddress tipaddr = (TransportIpAddress)address;
            byte[] addrBytes = tipaddr.getInetAddress().getAddress();
            OctetString addr = new OctetString(addrBytes);
            addr.append((byte)(tipaddr.getPort() >> 8));
            addr.append((byte)(tipaddr.getPort() & 0xFF));
            return addr;
        }
        return null;
    }
}

